<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Cupom</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2510.15.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2510.15.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.2510.15.1" />

  <link href='../dist/css/bootstrap.min.css?versao=3.2510.15.1'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2510.15.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2510.15.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2510.15.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.2510.15.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.2510.15.1">

  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2510.15.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2510.15.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.2510.15.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <style>
    .labelGeral {
      margin-top: 7px;
      margin-bottom: 3px;
    }

    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 100%;
      float: left;
      position: relative
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed" id="billGates">
  <div class="wrapper">


    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>

    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
              </div>
              <div class="col-sm-6">
                <!-- <ol class="breadcrumb float-sm-right">
                  
                  <li class="breadcrumb-item"><a href="../cadcupomdesconto">Acesso Cupom</a></li>
                  <li class="breadcrumb-item active">Cadastro de Cupom</li>
                </ol> -->
              </div>
            </div>
          </div>
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2> Cadastro de Cupom
                    <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>

                <div class="row">
                  <div class="col-md-12 mx-0 mb-3">
                    <form id="msform">
                      <ul id="progressbar">
                        <li class="active" id="account"><strong>Geral</strong></li>
                      </ul>
                      <p>Preencha os dados e clique em gravar para realizar o cadastro ou alteração do Cadastro de Cupom.</p>
                      <fieldset class="row justify-content-center mt-5">

                        <div class="row text-left col-10">
                          <div class="col-lg-6 col-12 form-group mb-3">
                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código *</label>
                            <input type="text" class="input-default focus form-control" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Código">
                          </div>
                          <div class="col-lg-6 col-12 form-group mb-3">
                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCupom">Descriçao *</label>
                            <input type="text" class="input-default focus form-control" id="txtDescricao" required aria-describedby="descError" name="txtDescricao" class="form-control" placeholder="Descrião">
                          </div>
                          <div class="col-lg-5 col-12 form-group mb-3" style="padding-top: 6px;">
                            <label data-error="wrong" data-success="right" class="mb-1" for="dtInicio">Inicio de/ Até: * </label>
                            <div class="input-group">
                              <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtInicio" name="dtInicio" class="form-control" style="border-radius: 4px;">    
                              <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtFim" name="dtFim" class="form-control" style="border-radius: 4px;">
                            </div>
                          </div>
                          <div class="col-lg-2 col-12 form-group mb-3">
                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtQuantidade">Quantidade *</label>
                            <div class="input-group">
                              <input type="text" class="input-default focus form-control" id="txtQuantidade" name="txtQuantidade" placeholder="Quantidade">
                            </div>
                          </div>
                          <div class="col-lg-2 col-12 form-group mb-3">
                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercDesc">% Desconto </label>
                            <div class="input-group">
                              <input type="text" class="input-default focus form-control" id="txtPercDesc" aria-describedby="histError" name="txtPercDesc" placeholder="Porcentagem de desconto">
                            </div>
                          </div>
                          <div class="col-lg-3 col-12 form-group mb-3">
                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtValorDesc">R$ Desconto </label>
                            <div class="input-group">
                              <input type="text" class="input-default focus form-control maskDecimais" id="txtValorDesc" aria-describedby="histError" name="txtValorDesc" placeholder="Valor de desconto">
                            </div>
                          </div>
                          <div class="col-lg-3 col-12 form-group mb-3 d-none">
                            <input type="text" class="input-default focus form-control" id="txtCliente" aria-describedby="histError" name="txtCliente" placeholder="cliente">
                          </div>
                          <!-- <div class="col-lg-3 col-12 form-group mb-3">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtValorDesc">Valor de Desconto*</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtValorDesc" required aria-describedby="histError" name="txtValorDesc" placeholder="Porcentagem de desconto">
                              </div>
                            </div> -->
                          <div class="col-lg-12 col-12 form-group">
                            <table id="tabela-empAcesso" class="table table-sm table-hover table-select table-condensed">
                              <thead>
                                <tr>
                                  <th>Sel</th>
                                  <th>Empresa</th>
                                  <th>Emp. Id</th>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>

                      </fieldset>
                      <input type="button" name="btnGravar" id="btnGravar" class="btn-sisp action-button" value="Gravar" />
                      <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>

        </div>
      </section>
    </div>
  </div>
  </div>

  <?php
  include_once('../../../modais.php');
  ?>

  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>

  <script src="../plugins/jquery/jquery.min.js?versao=3.2510.15.1"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2510.15.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2510.15.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2510.15.1"></script>
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.2510.15.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.2510.15.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2510.15.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.2510.15.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.2510.15.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.2510.15.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.2510.15.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.2510.15.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.2510.15.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.2510.15.1"></script>
  <script src="../utils/funcoes.js?versao=3.2510.15.1"></script>
  <script src="../utils/cookies.js?versao=3.2510.15.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.2510.15.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.2510.15.1"></script>
  <script src="../dist/js/dataTables.keyTable2.js?versao=3.2510.15.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.2510.15.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('CADCUPOMDESCONTO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("CADCUPOMDESCONTO");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/cadcupomdesconto`
        });
        return;
      }

      const queryString = window.location.href;
      const parametros = queryString.split('/');
      const cupom = parametros[parametros.length - 1];

      $(window).on("beforeunload", function(e) {
        // e.preventDefault();
        e.stopPropagation();
        deletaRegistro('CADCUPOMDESCONTO', getCookie('usuario'), cupom);
        return undefined;
      });

      sArquivo = `${BASE_URI}/pages/cadcupomdesconto/cadastro_cadcupomdesconto/cadcupomdesconto.js?versao=3.2510.15.1`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>
</body>

</html>