$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      onHighlightStarted: (Element) => {
        if (Element.node.id == 'geral') {
          if (!$('#DadosGerais').hasClass('show'));
          $('#DadosGerais').collapse('show');
        }
      },
    });

    driver.defineSteps([{
      element: '#txtNumero',
      popover: {
        title: 'Número do Pedido',
        description: 'Aqui consta o número do pedido, caso seja uma inclusão o número inserido irá ser consultado.',
        position: 'top'
      }
    },
    {
      element: '#DadosGerais',
      popover: {
        title: 'Dados e Ações do Cancelamento',
        description: 'Esses são os campos que você irá preencher para realizar a gravação do cancelamento do pedido.',
        position: 'bottom'
      }
    },
    {
      element: '#cbBaixarEstoque',
      popover: {
        title: 'Baixar Estoque',
        description: 'Ao ser selecionado, irá baixar o estoque de toda a quantidade que está sendo cancelada e/ou faturada.',
        position: 'bottom'
      }
    },
    {
      element: '#cbExcluirReserva',
      popover: {
        title: 'Excluir Reserva',
        description: 'Ao ser selecionado, irá excluir toda a quantidade em expedição reserva.',
        position: 'bottom'
      }
    },
    {
      element: '#cbVoltaExpedicao',
      popover: {
        title: 'Volta Expedição',
        description: 'Ao ser selecionado, voltará toda a quantidade em expedição.',
        position: 'bottom'
      }
    },
    {
      element: '#opcoesQtde',
      popover: {
        title: 'Opções',
        description: 'Aqui existem algumas opções para manipular as quantidades de cancelamento e faturamento desse pedido.',
        position: 'bottom'
      }
    },
    {
      element: '#cbCancelarTotal',
      popover: {
        title: 'Cancelamento Total das Quantidades',
        description: 'Está primeira opção ao ser selecionada, passa para cancelado toda a quantidade pendente do grid.',
        position: 'bottom'
      }
    },
    {
      element: '#cbFatTotal',
      popover: {
        title: 'Faturamento Total das Quantidades',
        description: 'Está segunda opção ao ser selecionada, passa para faturada toda a quantidade pendente do grid.',
        position: 'bottom'
      }
    },
    {
      element: '#cbFatExpedicao',
      popover: {
        title: 'Faturamento Total das Quantidades',
        description: 'Está terceira opção ao ser selecionada, passa para faturada toda a quantidade pendente em expedição do grid.',
        position: 'bottom'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Ao clicar nesse botão você grava os dados inseridos.',
        position: 'left'
      }
    }
    ]);

    driver.start();
  });
});


$(document).ready(async function () {
  // linhaC = 1; 
  $('#txtCliente').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtGrupoProd').autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtMarca').autocompleta(1, `JSON={ "tabela":"MARCA", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtMotivo').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $("#txtDeposito").autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtTipoMvto').autocompleta(1, `JSON={ "tabela":"TABBAI", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"TABQUL", "camposSelect":["CODIGO CODIGO", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtEtiqueta').autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  // $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}`, 'Pesquisa de Cliente');
  $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente');
  $('#btnGrupoProd').pesquisa('#txtGrupoProd', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Grupo Produto', 'GRUPO_PA');
  $('#btnMarca').pesquisa('#txtMarca', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MARCA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Marca', 'MARCA');
  $('#btnMotivo').pesquisa('#txtMotivo', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo', 'MENSAGEM');
  $("#btnDeposito").pesquisa("#txtDeposito", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Depósito", "DEPOSITO");
  $('#btnTipoMvto').pesquisa('#txtTipoMvto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Tipo Movimento', 'TABBAI');
  $('#btnQualidade').pesquisa('#txtQualidade', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Qualidade', 'TABQUL');
  $('#btnEtiqueta').pesquisa('#txtEtiqueta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Etiqueta', 'ETQ_PROD');

  $('#btnLimpaCliente').on('click', function () {
    $('#txtCliente').val('');
  });

  $('#btnLimpaDeposito').on('click', function () {
    $('#txtDeposito').val('');
  });

  $('#btnLimpaMotivo').on('click', function () {
    $('#txtMotivo').val('');
  });

  $('#btnLimpaTipoMvto').on('click', function () {
    $('#txtTipoMvto').val('');
  });

  $('#btnLimpaQualidade').on('click', function () {
    $('#txtQualidade').val('');
  });

  $('#btnLimpaEtiqueta').on('click', function () {
    $('#txtEtiqueta').val('');
  });

  componenteFiltro('cliente', false, false)

  $('#txtNumero').autocompleta(
    1,
    `JSON={ "tabela":"PEDIDO", "camposSelect":["NUMERO CHAVE, CODCLI DESCRICAO"], "where": [] }`,
    ['#txtNumero', '#txtNumero'],
    ['CHAVE', 'DESCRICAO'],
    ['CHAVE', 'DESCRICAO'],
    () => null,
    [true],
    '',
    [],
    true,
  )
  $('#btnNumero').pesquisa_serverside(
    ['#txtNumero'],
    ['NUMERO', 'CODCLI'],
    ['NUMERO', 'CODCLI'],
    '{"tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI"], "where": null}',
    'Pesquisa Pedido',
    () => null,
    [true]
  )

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let pedido = parametros[parametros.length - 1];

  function criaTabelaItens(data) {
    const dataSetCols = [
      {
        data: 'codigo',
        title: 'Código'
      },
      {
        data: 'descProduto',
        title: 'Descrição'
      },
      {
        data: 'cor',
        title: 'Cor'
      },
      {
        data: 'descCor',
        title: 'Desc. Cor'
      },
      {
        data: 'tam',
        title: 'Tam'
      },
      {
        data: 'precoLiq',
        title: 'Preço Liq.',
        className: 'pr-4 text-right'
      },
      {
        data: 'qtdeOrig',
        title: 'Qtde Orig.',
        className: 'pr-4 text-right'
      },
      {
        data: 'qtde',
        title: 'Qtde',
        className: 'pr-4 text-right'
      },
      {
        data: 'cancelada',
        title: 'Cancelada',
        render: function (_, _1, _2, { row }) {
          return `<div>
                    <div class="input-group flex-nowrap">
                      <input type="text" class="input-default focus form-control stepControlPedido${row} txtCancelar" id="txtCancelar_${row}" name="txtCancelar_${row}" placeholder="0" style="max-width: 71px">
                    </div>
                  </div>`
        }
      },
      {
        data: 'faturada',
        title: 'Faturada',
        visible: false
      },
      {
        data: 'qtdeCanc',
        title: 'Qtde Canc.',
        className: 'pr-4 text-right'
      },
      {
        data: 'qtdeFat',
        title: 'Qtde Fat.',
        className: 'pr-4 text-right'
      },
      {
        data: 'idItemPed',
        title: 'Id Item Ped',
        visible: false
      },
      {
        data: 'ordem',
        title: 'Ordem',
        visible: false
      },
      {
        data: 'reservada',
        title: 'Reservada',
        visible: false
      },
      {
        data: 'qtdeResB',
        title: 'Qtde Res. B.',
        visible: false
      },
      {
        data: 'qualidade',
        title: 'Qualidade',
        visible: false
      },
      {
        data: 'tipo',
        title: 'Tipo',
        visible: false
      },
      {
        data: 'expedicao',
        title: 'Expedicao',
        visible: false
      },
    ]

    $('#tabelaPedido').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: [],
      colReorder: false,
      destroy: true,
      scrollY: '350px',
      columns: dataSetCols,
      data,
      createdRow: function (row, data, dataIndex) {
        $('td', row).eq(7).css('color', 'green');
        $('td', row).eq(9).css('color', 'red');
        $('td', row).eq(6).css('font-weight', 'bold');
        $('td', row).eq(7).css('font-weight', 'bold');
        $('td', row).eq(9).css('font-weight', 'bold');
      }
    });
  }

  $('#tabelaPedido').on('blur', '.txtCancelar', function () {
    const qtde = $(this).val();
    if (parseInt(qtde) > parseInt($('#tabelaPedido').DataTable().row($(this).parents('tr'))?.data()?.qtde ?? 0)) {
      $(this).val(0)
      throw msgAlerta(`Quantidade a cancelar: ${qtde}, maior que o saldo do item do pedido: ${$('#tabelaPedido').DataTable().row($(this).parents('tr'))?.data()?.qtde ?? 0}, impossível continuar.`);
    }
  });

  $('#txtNumero').on('blur', async function () {
    $.LoadingOverlay('show')
    try {
      if ($('#txtNumero').val() && $('#txtNumero').val() != '') {
        let data = await buscaDadosPedidos($('#txtNumero').val());
        criaTabelaItens(data.itens)
        await preencheDadosPedido()
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  if (pedido != '' && pedido != 'create') {
    $('#txtNumero').val(pedido);
    $.LoadingOverlay("show");
    try {

      let data = await buscaDadosPedidos(pedido);

      criaTabelaItens(data.itens)
      await preencheDadosPedido()
    } catch (error) {
      console.error(error)
      msgAlerta(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function preencheDadosPedido() {
    let pedcli = await buscaValor('PEDIDO', 'PED_CLI', 'NUMERO', $('#txtNumero').val());
    if (pedcli != undefined) {
      pedcli = pedcli.PED_CLI;
      $('#txtPedCliente').val(pedcli);
    }

    let cliente = await buscaValor('PEDIDO', 'CODCLI', 'NUMERO', $('#txtNumero').val());
    if (cliente != undefined) {
      cliente = cliente.CODCLI;
      insereValor('#txtCliente', cliente, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: cliente });
    }

    let deposito = await buscaValor('PEDIDO', 'DEPOSITO', 'NUMERO', $('#txtNumero').val());
    if (deposito != undefined) {
      deposito = deposito.DEPOSITO;
      insereValor('#txtDeposito', deposito, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: deposito });
    }

    if (await validaCheckReceber($('#txtNumero').val())) {
      if (await buscaParametroERP('VEN', '1010', '1', '1') == 'N') {
        $('#cbGerarReceber').prop('disabled', true)
      }
    }
  }

  async function validaCheckReceber(sPedido) {
    try {
      const dadosSelect = {
        tabela: 'RECEBER',
        camposSelect: ['NUMERO'],
        where: [`PEDIDO = '${sPedido}'`]
      };
      const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
      if (!retornoSelect) {
        return;
      }
      if (retornoSelect.length == 0) {
        return false;
      }
      return true;
    } catch (error) {
      console.error(error)
    }
  }

  $('#cbCancelarTotal').on('click', function () {
    $(`.inputsFaturada`).val('');
    for (let i = 0; i < $('#tabelaPedido').DataTable().data().length; i++) {
      $(`#txtCancelar_${i}`).val($('#tabelaPedido').DataTable().data()[i].qtde)
    }
  });

  async function buscaDadosPedidos(pedido) {
    const response = await requisicao("GET", `/sisplan/cancelamentopedido/v1/buscadadositens?`, `&NUMERO=${pedido}`, '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  };

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('CANCELAMENTO_PEDIDO', getCookie('usuario'), pedido);
    window.location.href = `${BASE_URI}/cancelamento_pedido`;
  });

  $('#btnVoltarFaturado').on('click', async function () {
    if (($('#txtDeposito').val() != '') && ($('#cbBaixarEstoque').is(':checked'))) {
      throw msgAlerta('Depósito precisa ser informado, verifique!');
    }

    if (($('#txtTipoMvto').val()) != '' && ($('#cbBaixarEstoque').is(':checked'))) {
      throw msgAlerta('Tipo motivo precisa ser informado, verifique!');
    }
    await msgAlerta(
      'Deseja voltar as quantidades faturadas?',
      async function () {
        await voltarQuantidadeFat();
      },
      async function () {
        () => { }
      }
    );
  });

  async function voltarQuantidadeFat() {
    try {
      $.LoadingOverlay('show');
      const ListaItensPedido = buscaDadosTabela();
      const params = buscaParams();

      let objeto = { ListaItensPedido };
      let response = await requisicao('POST', `/sisplan/cancelamentopedido/v1/voltarfaturado?`, '', `JSON=${JSON.stringify(objeto)}${params}`, 15000);

      if (!response) {
        return;
      }

      toastr.success(
        `Voltado quantidades faturadas!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cancelamento_pedido`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (err) {
      console.log(err)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function voltarQuantidadeCanc() {
    try {
      $.LoadingOverlay('show');
      const ListaItensPedido = buscaDadosTabela();
      const params = buscaParams();

      let objeto = { ListaItensPedido };
      let response = await requisicao('POST', `/sisplan/cancelamentopedido/v1/voltarcancelado?`, '', `JSON=${JSON.stringify(objeto)}${params}`, 15000);

      if (!response) {
        return;
      }

      toastr.success(
        `Voltado quantidades canceladas!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cancelamento_pedido`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (err) {
      console.log(err)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function buscaDadosTabela() {
    const tb = $('#tabelaPedido').DataTable();

    // feito dessa forma por conta da ordenação quando clica no columns do datatable
    const listaItensPedido = tb.rows({ order: 'applied', search: 'applied' }).indexes().toArray().map(i => {
      const data = tb.row(i).data();
      const $input = $(`#txtCancelar_${i}`);

      return {
        CODIGO: data.codigo,
        DESCRICAO: data.descProduto,
        COR: data.cor,
        DESCCOR: data.descCor,
        TAM: data.tam,
        PRECOLIQ: data.precoLiq,
        QTDE_ORIG: data.qtdeOrig,
        QTDE: data.qtde,
        CANCELADA: Number($input.val()) || 0,
        QTDE_CANC: data.qtdeCanc,
        QTDE_F: data.qtdeFat,
        ID_ITEM_PED: data.idItemPed,
        ORDEM: data.ordem,
        RESERVADO: data.reservada,
        QTDE_RES_B: data.qtdeResB,
        QUALIDADE: data.qualidade,
        TIPO: data.tipo,
        EXPEDICAO: data.expedicao,
      };
    });

    return listaItensPedido;
  }

  function buscaDadosTabelaGravar() {
    const tb = $('#tabelaPedido').DataTable();

    let somaQtde = 0;
    let somaCanc = 0;

    // feito dessa forma por conta da ordenação quando clica no columns do datatable
    const listaItensPedido = tb.rows({ order: 'applied', search: 'applied' })
      .indexes()
      .toArray()
      .map(i => {
        const data = tb.row(i).data();
        const $input = $(`#txtCancelar_${i}`);
        const qtdeCanc = Number($input.val()) || 0;

        somaQtde += Number(data.qtde) || 0;
        somaCanc += qtdeCanc;

        return {
          CODIGO: data.codigo,
          DESCRICAO: data.descProduto,
          COR: data.cor,
          DESCCOR: data.descCor,
          TAM: data.tam,
          PRECOLIQ: data.precoLiq,
          QTDE_ORIG: data.qtdeOrig,
          QTDE: data.qtde,
          CANCELADA: qtdeCanc,
          QTDE_CANC: data.qtdeCanc,
          QTDE_F: data.qtdeFat,
          ID_ITEM_PED: data.idItemPed,
          ORDEM: data.ordem,
          RESERVADO: data.reservada,
          QTDE_RES_B: data.qtdeResB,
          QUALIDADE: data.qualidade,
          TIPO: data.tipo,
          EXPEDICAO: data.expedicao,
        };
      })
      .filter(item => item.CANCELADA > 0);

    return {
      registros: listaItensPedido,
      qtde: somaQtde,
      qtdeCanc: somaCanc
    };
  }

  function buscaParams() {
    //CHECKBOX
    let sBaixar_estoque = $('#cbBaixarEstoque').is(':checked') ? 'S' : 'N';
    let sGerar_receber = $('#cbGerarReceber').is(':checked') ? 'S' : 'N';
    let sImpConfigurada = $('#cbImpressaoConfigurada').is(':checked') ? 'S' : 'N';
    let sExcluirReserva = $('#cbExcluirReserva').is(':checked') ? 'S' : 'N';
    let sSomenteQtdePendente = $('#cbSomenteQtdePendente').is(':checked') ? 'S' : 'N';
    let sVoltaExpedicao = $('#cbVoltaExpedicao').is(':checked') ? 'S' : 'N';
    let sUtiliza_barra = $('#cbUtilizaBarra').is(':checked') ? 'S' : 'N';
    //RADIO
    let sCancelarTotal = $('#cbCancelarTotal').is(':checked') ? 'S' : 'N';
    let sFaturarTotal = $('#cbFaturarTotal').is(':checked') ? 'S' : 'N';
    let sFaturarExpedicao = $('#cbFatExpedicao').is(':checked') ? 'S' : 'N';
    //CAMPOS    
    let sNumero = $('#txtNumero').val();
    let sNotaFiscal = $('#txtNotaFiscal').val();
    let sPedCliente = $('#txtPedCliente').val();
    let sCodigo = $('#txtCodigo').val();
    let sCliente = pegaChave('#txtCliente');
    let sDeposito = pegaChave('#txtDeposito');
    let sGrupoProd = pegaChave('#txtGrupoProd');
    let sMarca = pegaChave('#txtMarca');
    let sMotivo = pegaChave('#txtMotivo');
    let sTipoMvto = pegaChave('#txtTipoMvto');
    let sQualidade = pegaChave('#txtQualidade');
    let sEtiqueta = pegaChave('#txtEtiqueta');
    let sBarra = $('#txtBarra').val();
    let sObs = $('#txtObs').val();
    //TOTALIZADORES
    let sValorLiq = $('#txtValorTotalLiq').val()

    let retorno =
      `&EMP_ID=${getCookie('emp_id')}` +
      //CHECKBOX
      `&BAIXAR_ESTOQUE=${sBaixar_estoque}` +
      `&GERAR_RECEBER=${sGerar_receber}` +
      `&IMP_CONFIGURADA=${sImpConfigurada}` +
      `&EXCLUI_RESERVA=${sExcluirReserva}` +
      `&SOMENTE_QTDE_PENDENTE=${sSomenteQtdePendente}` +
      `&VOLTAR_EXPEDICAO=${sVoltaExpedicao}` +
      `&UTILIZA_BARRA=${sUtiliza_barra}` +
      //RADIO
      `&CANCELAR_TOTAL=${sCancelarTotal}` +
      `&FATURAR_TOTAL=${sFaturarTotal}` +
      `&FATURAR_EXPEDICAO=${sFaturarExpedicao}` +
      //CAMPOS
      `&NUMERO=${sNumero}` +
      `&NOTA_FISCAL=${sNotaFiscal}` +
      `&PED_CLIENTE=${sPedCliente}` +
      `&CODIGO=${sCodigo}` +
      `&CODCLI=${sCliente}` +
      `&DEPOSITO=${sDeposito}` +
      `&GRUPO_PRODUTO=${sGrupoProd}` +
      `&MARCA=${sMarca}` +
      `&MOTIVO=${sMotivo}` +
      `&TIPO_MVTO=${sTipoMvto}` +
      `&QUALIDADE=${sQualidade}` +
      `&ETIQUETA=${sEtiqueta}` +
      `&BARRA=${sBarra}`;
    // `&OBS=${sObs}` +
    //TOTALIZADORES
    // `&VALOR_LIQUIDO=${sValorLiq}`;

    return retorno;
  };

  async function gravaCancelamento() {
    try {
      $.LoadingOverlay('show');
      const ListaItensPedido = buscaDadosTabelaGravar();
      const params = buscaParams();

      let objeto = { ListaItensPedido: ListaItensPedido.registros };
      let response = await requisicao('POST', `/sisplan/cancelamentopedido/v1/gravar?`, '', `JSON=${JSON.stringify(objeto)}${params}&QTDE=${ListaItensPedido.qtde}&QTDE_CANC=${ListaItensPedido.qtdeCanc}`, 60000);

      if (!response) {
        return;
      };

      if (response.status != 200) {
        let jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success(
        `Dados gravados com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cancelamento_pedido`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnVoltarCancelado').on('click', async function () {
    await msgAlerta(
      'Deseja voltar as quantidades canceladas?',
      async function () {
        await voltarQuantidadeCanc();
      },
      async function () {
        () => { }
      }
    );
  });

  $('#btnGravar').on('click', async function () {
    validacoesGravar();

    if ($('#cbGerarReceber').is(':checked')) {
      $('#modalGeraDuplicatas').modal('show');
    } else {
      await gravaCancelamento();
    }
  });


  function validacoesGravar() {
    if (!$('#txtDeposito').val() && $('#cbBaixarEstoque').is(':checked')) {
      throw msgAlerta('O depósito deve ser informado, verifique!');
    };

    if (!$('#txtMotivo').val()) {
      throw msgAlerta('O motivo deve ser informado, verifique!');
    };

    let qtde = 0;
    $('#tabelaPedido').DataTable().data().toArray().forEach((item, index) => {
      qtde += parseInt($(`#txtCancelar_${index}`).val());
      if (parseInt($(`#txtCancelar_${index}`).val()) > parseInt(item.qtde)) {
        $(`#txtCancelar_${index}`).focus();
        throw msgAlerta('Quantidade a cancelar maior que o saldo do pedido, impossível continuar.');
      }
    })

    if (qtde === 0) {
      throw msgAlerta('Nenhuma quantidade informada, impossível continuar.');
    }
  };

  //// AQUI COMEÇA AS FUNÇÕES DO MODAL DE GERAR DUPLICATA

  $('#modalGeraDuplicatas').on('shown.bs.modal', async function () {
    $.LoadingOverlay('show')
    try {
      $('#txtClasseGer').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
      $('#btnClasseGer').pesquisa('#txtClasseGer', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Classe Gerencial', 'CLASSE_GER');
      $('#btnLimpaClasseGer').on('click', function () {
        $('#txtClasseGer').val('');
      });

      $('#txtHistorico').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
      $('#btnHistorico').pesquisa('#txtHistorico', 'HISTORICO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"]}`, 'Pesquisa de Histórico', 'HISTCP');
      $('#btnLimpaHistorico').on('click', function () {
        $('#txtHistorico').val('');
      });

      $('#txtBanco').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
      $('#btnBanco').pesquisa('#txtBanco', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"]}`, 'Pesquisa de Banco', 'BANCO');
      $('#btnLimpaBanco').on('click', function () {
        $('#txtBanco').val('');
      });

      $('#txtSituacao').autocompleta(1, `JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
      $('#btnSituacao').pesquisa('#txtSituacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Situação', 'TABSIT');
      $('#btnLimpaSituacao').on('click', function () {
        $('#txtSituacao').val('');
      });

      $('#txtConta').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
      $('#btnConta').pesquisa('#txtConta', 'CONTA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"]}`, 'Pesquisa de Conta', 'CADCONTA');
      $('#btnLimpaConta').on('click', function () {
        $('#txtConta').val('');
      });

      if ($('#txtClasseGer').val() == '') {
        const pesquisaClassePadrao = {
          tabela: 'ENTIDADE',
          camposSelect: ['ENTIDADE.CLASSE', 'CLASSE_GER.DESCRICAO'],
          innerJoin: [{ 'tabela': 'CLASSE_GER', 'condicao': 'ENTIDADE.CLASSE = CLASSE_GER.CODIGO' }],
          where: [`ENTIDADE.CODCLI = '${pegaChave('#txtCliente')}'`]
        };

        const jsonClassePadrao = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaClassePadrao));

        if (jsonClassePadrao.length > 0) {
          $('#txtClasseGer').val(`[${jsonClassePadrao[0].CLASSE}] - ${jsonClassePadrao[0].DESCRICAO}`);
        };
      };

      if ($('#txtHistorico').val() == '') {
        const pesquisaHistoricoPadrao = {
          tabela: 'ENTIDADE',
          camposSelect: ['ENTIDADE.HISTORICO', 'HISTCP.DESCRICAO'],
          innerJoin: [{ 'tabela': 'HISTCP', 'condicao': 'HISTCP.HISTORICO = ENTIDADE.HISTORICO' }],
          where: [`ENTIDADE.CODCLI = '${pegaChave('#txtCliente')}'`]
        };

        const jsonHistoricoPadrao = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaHistoricoPadrao));

        if (jsonHistoricoPadrao.length > 0) {
          $('#txtHistorico').val(`[${jsonHistoricoPadrao[0].HISTORICO}] - ${jsonHistoricoPadrao[0].DESCRICAO}`);
        };
      };

      if ($('#txtBanco').val() == '') {
        const pesquisaBancoPadrao = {
          tabela: 'ENTIDADE',
          camposSelect: ['ENTIDADE.BANCO', 'CADBAN.NOME_BANCO'],
          innerJoin: [{ 'tabela': 'CADBAN', 'condicao': 'ENTIDADE.BANCO = CADBAN.BANCO' }],
          where: [`ENTIDADE.CODCLI = '${pegaChave('#txtCliente')}'`]
        };

        const jsonBancoPadrao = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaBancoPadrao));

        if (jsonBancoPadrao.length > 0) {
          $('#txtBanco').val(`[${jsonBancoPadrao[0].BANCO}] - ${jsonBancoPadrao[0].NOME_BANCO}`);
        };
      };

      if ($('#txtSituacao').val() == '') {
        const pesquisaSituacaoPadrao = {
          tabela: 'EMPRESA',
          camposSelect: ['EMPRESA.EMP_SITUACAO', 'TABSIT.DESCRICAO'],
          innerJoin: [{ 'tabela': 'TABSIT', 'condicao': 'EMPRESA.EMP_SITUACAO = TABSIT.CODIGO' }],
          where: [`EMPRESA.EMP_ID = ${getCookie('emp_id')}`]
        };

        const jsonSituacaoPadrao = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaSituacaoPadrao));

        if (jsonSituacaoPadrao.length > 0) {
          $('#txtSituacao').val(`[${jsonSituacaoPadrao[0].EMP_SITUACAO}] - ${jsonSituacaoPadrao[0].DESCRICAO}`)
        }
      };

      const pesquisaCondicaoPagto = {
        tabela: 'PEDIDO',
        camposSelect: ['PGTO'],
        where: [`NUMERO = '${$('#txtNumero').val()}'`]
      };

      const jsonStrCondicaoPagamento = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCondicaoPagto));

      const infoDatatable = $('#tabelaPedido').DataTable().rows().data().toArray();

      let valorTot = 0;

      infoDatatable.forEach((info, index) => {
        let quantidade = parseInt($(`#txtFaturada_${index}`).val());
        quantidade = isNaN(quantidade) ? 0 : quantidade;
        valorTot += parseFloat(info.precoLiq) * quantidade;
      });

      if (valorTot <= 0) {
        $('#modalGeraDuplicatas').modal('hide')
        msgAlerta('Impossível gerar receber sem quantidades a faturar!')
        return;
      }

      const listaDuplicatas = await geraDuplicatas(jsonStrCondicaoPagamento[0].PGTO, valorTot);

      if ($.fn.DataTable.isDataTable('#tabelaGeraDuplicatas')) {
        $('#tabelaGeraDuplicatas').DataTable().destroy();
        $('#tabelaGeraDuplicatas').empty();
      };

      $('#tabelaGeraDuplicatas').DataTable({
        destroy: true,
        searching: false,
        lengthChange: false,
        scrollX: false,
        order: false,
        ///autoWidth: true,
        data: listaDuplicatas,
        columns: [
          {
            data: "dtVencto",
            title: "Data Vencto"
          },
          {
            data: "vValorDup",
            title: "Valor Duplicata"
          }
        ],
        "columnDefs": [
          {
            "targets": 0,
            "className": "text-left"
          }
        ],
        "columnDefs": [
          {
            "targets": 1,
            "className": "text-right"
          }
        ]
      });
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  function buscaDuplicatas() {
    const arrayDup = []
    let objDup = {}
    let vValorTot = 0
    const dupDataTable = $('#tabelaGeraDuplicatas').DataTable().rows().data().toArray();

    for (let j = 0; j < dupDataTable.length; j++) {
      vValorTot = parseFloat(parseFloat(vValorTot) + parseFloat(dupDataTable[j].vValorDup));
    }

    for (let i = 0; i < dupDataTable.length; i++) {
      objDup.DTVENCTO = formataDataComTraco(dupDataTable[i].dtVencto)
      objDup.VALOR = dupDataTable[i].vValorDup
      objDup.VALORTOT = vValorTot
      objDup.CLASSE = pegaChave('#txtClasseGer')
      objDup.HISTORICO = pegaChave('#txtHistorico')
      objDup.BANCO = pegaChave('#txtBanco')
      objDup.CONTA = pegaChave('#txtConta')
      objDup.SITUACAO = pegaChave('#txtSituacao')
      objDup.EMPDEMO = $('#cbGeraEmpDemo').is(':checked') ? 'S' : 'N'

      arrayDup.push(objDup)
      objDup = {}
    }

    return arrayDup
  }

  $('#btnConfirmaDup').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      try {
        if ($('#txtClasseGer').val() == '') {
          msgAlerta('Classe Gerencial não informada!')
          return;
        }

        if ($('#txtHistorico').val() == '') {
          msgAlerta('Histórico não informado!')
          return;
        }

        if ($('#txtBanco').val() == '') {
          msgAlerta('Banco não informado!')
          return;
        }

        if ($('#txtSituacao').val() == '') {
          msgAlerta('Situação não informada!')
          return;
        }

        if ($('#txtConta').val() == '') {
          msgAlerta('Conta não informada!')
          return;
        }

        const listaReceberCancelamento = buscaDuplicatas();

        const obj = { listaReceberCancelamento }
        const params = buscaParams();
        const response = await requisicao('POST', `/sisplan/cancelamentopedido/v1/gravarduplicatas?`, '', `JSON=${JSON.stringify(obj)}${params}`, 60000);

        if (!response) {
          msgAlerta('Ocorreu um erro ao gravar duplicatas!')
          return;
        };

        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        $('#modalGeraDuplicatas').modal('hide')
        await gravaCancelamento();

      } catch (error) {
        console.log(error)
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  function formataData(data) {
    const dtVencimento = (data.getDate() < 9 ? '0' + String(data.getDate()) : String(data.getDate())) + '/' + ((data.getMonth() + 1) < 9 ? '0' + String(data.getMonth() + 1) : String(data.getMonth() + 1)) + '/' + String(data.getFullYear());
    return dtVencimento
  };

  async function geraDuplicatas(condicaoPagto, vValor) {
    let nParcelas = condicaoPagto.trim().split(' ').length;
    let listaParcelas = condicaoPagto.trim().split(' ')
    let listaVenctos = [];

    for (let i = 1; i <= nParcelas; i++) {
      let dias = parseInt(listaParcelas[i - 1]);
      let dtVencimento = new Date();
      let valorDup = 0;
      dtVencimento.setDate(dtVencimento.getDate() + dias);

      if (i != nParcelas) {
        valorDup = roundTo((vValor / nParcelas), 2);
      } else {
        valorDup = (vValor - ((nParcelas - 1) * roundTo(vValor / nParcelas, 2)));
      };

      listaVenctos.push({
        dtVencto: formataData(dtVencimento),
        vValorDup: valorDup.toFixed(2)
      });
    };

    return listaVenctos
  };
});