$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([
            {
                element: '#abaGeral',
                popover: {
                    title: 'Campos de Filtro',
                    description: 'Campos para filtrar as reservas.',
                    position: 'bottom'
                }
            },
            {
                element: '#btnConsultar',
                popover: {
                    title: 'Botão Consultar',
                    description: 'Clique aqui para realizar a consulta de reservas.',
                    position: 'left'
                }
            },
            {
                element: '#btnImprimir',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para realizar a impressão dos registros filtrados.',
                    position: 'left'
                }
            },
            {
                element: '#btnExcluirReserva',
                popover: {
                    title: 'Botão Excluir Reserva',
                    description: 'Clique aqui para excluir as reservas selecionadas.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    addPesquisaAutocompleta();

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (colunas == null || colunas.excluiReserva == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, excluiReserva: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    function validaNovasColunas(novasColunas) {
        if (novasColunas.includes('SEL')) {
            throw new Error('Impossível deixar a coluna SEL invisível, favor desmarcar a mesma!');
        }
    }

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();

            validaNovasColunas(novasColunas)

            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, excluiReserva: novasColunas }))
            $('#tabelaPedido').DataTable().columns().visible(true);
            $('#tabelaPedido').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })
            $('#modal-ColunasVisiveis').modal('hide');
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#btnConsultar').on('click', async () => { await buscaReservas() });

    async function retornaFiltros() {
        const reservaPendente = $('#cbReservasPendentes').is(':checked') ? 'S' : 'N';
        const filtros =
            `EMISSAODE=${$('#txtDtEmissaoDe').val()}` +
            `&EMISSAOATE=${$('#txtDtEmissaoAte').val()}` +
            `&RESERVADE=${$('#txtDtReservaDe').val()}` +
            `&RESERVAATE=${$('#txtDtReservaAte').val()}` +
            `&FATURADE=${$('#txtDtFaturaDe').val()}` +
            `&FATURAATE=${$('#txtDtFaturaAte').val()}` +
            `&PRODUTOS=${await formataListas($('#txtProduto').val().toString())}` +
            `&PEDIDOS=${await formataListas($('#txtPedido').val().toString())}` +
            `&COR=${await formataListas($('#txtCor').val().toString())}` +
            `&TAMANHO=${await formataListas($('#txtTamanho').val().toString())}` +
            `&GRUPOPA=${await formataListas($('#txtGrupoPA').val().toString())}` +
            `&REPRESENTANTE=${await formataListas($('#txtRepresentante').val().toString())}` +
            `&RESERVAS=${await formataListas($('#txtReserva').val().toString())}` +
            `&DEPOSITO=${await formataListas($('#txtDeposito').val().toString())}` +
            `&GRUPOCLI=${await formataListas($('#txtGrupoCli').val().toString())}` +
            `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
            `&GRUPOPEDIDO=${await formataListas($('#txtGrupoPedido').val().toString())}` +
            `&COLECAO=${await formataListas($('#txtColecao').val().toString())}` +
            `&TIPOPEDIDO=${await formataListas($('#txtTipoPedido').val().toString())}` +
            `&STATUSPEDIDO=${await formataListas($('#txtStatusPed').val().toString())}` +
            `&ETIQUETA=${await formataListas($('#txtEtiqueta').val().toString())}` +
            `&RESERVASPENDENTES=${reservaPendente}`;
        return filtros;
    }

    async function buscaReservas() {
        if ($.fn.DataTable.isDataTable('#tabelaPedido')) {
            $("#tabelaPedido").DataTable().destroy();
            $("#tabelaPedido").empty();
        };
        $.LoadingOverlay('show')
        try {
            $('#txtQtdeReservada').val('')
            $('#txtQtdeBaixada').val('')
            const url = "/sisplan/excluireserva/v1/buscareservas?";
            const filtros = await retornaFiltros()
            const response = await requisicao("GET", url, `${filtros}`, "", 360000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem);
                return;
            }

            if (jsonStr.length <= 0) {
                throw new Error('Nenhum registro encontrado!')
            }

            await montaDataTableReservas(jsonStr)
            await preecnheTotalizadores()
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function montaDataTableReservas(jsonStr) {
        const dataSetCols = []
        const keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        dataSetCols[0].render = function (data, type, row, meta) {
            return '<div class="form-check pl-0">' +
                '<div class="icheck-primary">' +
                `<input style="height:20px" type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="align-self-center campoCheck"><label for="check_col_${meta.row}_row_${meta.col}"></label>` +
                '</div>' +
                '</div>';
        }

        $('#tabelaPedido').DataTable({
            bPaginate: true,
            destroy: true,
            colReorder: true,
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    render: function (data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [28, 34],
                },
                {
                    type: "date-br",
                    render(data) {
                        return data ? new Intl.DateTimeFormat("pt-BR").format(
                            new Date(`${data.split(" ")[0]} 23:59:59`)
                        ) : data;
                    },
                    targets: [25, 26, 32],
                },
                {
                    className: 'text-center',
                    targets: [6, 7, 8, 16, 17, 22, 23, 35]
                },
                {
                    className: 'text-left',
                    targets: [0]
                },
            ],

        });

        $('#tabelaPedido_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaPedido_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $("#tabelaPedido_length").parent().append(`<div class="col-sm-12 icheck-primary d-inline">` +
            `<input class="form-check-input" type="checkbox" id="checkSelecionarTodos">` +
            `<label class="form-check-label" for="checkSelecionarTodos">Selecionar Todos</label>` +
            `</div>`);

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#tabelaPedido').on('click', '.campoCheck', function () {
            const row = parseInt(this.id.split('col_')[1].split('_row')[0])
            if (this.checked) {
                $('#tabelaPedido').DataTable().row(row).data().SEL = 'S'
            } else {
                $('#tabelaPedido').DataTable().row(row).data().SEL = 'N'
            }
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#buttonColVis').on('click', async function () {
            $.LoadingOverlay('show')
            try {
                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $('#buttonExcel').on('click', async function () {
            const url = "/sisplan/excluireserva/v1/buscareservas?";
            const filtros = await retornaFiltros()
            await exportaCSV(url, filtros, false, null, 'Relatório de Exclusão de Reservas', '#tabelaPedido');
        })

        $('#tabelaPedido').DataTable().columns().every(
            function () {
                if ((colunasInvisiveis.excluiReserva).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            })

        $('#checkSelecionarTodos').on('change', async function () {
            async function callBack() {
                $.LoadingOverlay("show");
                try {
                    $("#tabelaPedido").DataTable().page.len(200).draw(false);
                    $($(".page-link")[1]).trigger("click");
                    const totalPaginas = $("#tabelaPedido").DataTable().page.info().pages;

                    for (let i = 1; i <= totalPaginas; i++) {
                        $('input[class=campoCheck]:checked').trigger('click');
                        $(".campoCheck").trigger("click");
                        $("#tabelaPedido_next").trigger("click");
                        await sleep(25)
                        if (totalPaginas == i) {
                            $($(".page-link")[1]).trigger("click");
                            $("#tabelaPedido").DataTable().page.len(10).draw(false);
                        }
                    };
                } finally {
                    $.LoadingOverlay("hide");
                }
            }

            msgAlerta(`Tem certeza que deseja ${!$("#checkSelecionarTodos").prop("checked") ? "desconsiderar" : "selecionar"} todos os registros? \nEssa ação percorrerá todas as páginas da tabela e resultará na seleção completa dos registros.`,
                callBack,
                () => { $("#checkSelecionarTodos").prop("checked", !$("#checkSelecionarTodos").prop("checked")); },
                undefined,
                () => { $("#checkSelecionarTodos").prop("checked", !$("#checkSelecionarTodos").prop("checked")); },
                true);
        });
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaPedido').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.excluiReserva ?? [])
    })

    async function preecnheTotalizadores() {
        $.LoadingOverlay('show')
        try {
            let totalQtde = 0;
            let totalQtdeB = 0;

            $('#tabelaPedido').DataTable().rows().every(function () {
                const item = this.data();

                totalQtde = parseFloat(totalQtde) + parseFloat(item.QTDE)
                totalQtdeB = parseFloat(totalQtdeB) + parseFloat(item.QTDE_B)
            })

            $('#txtQtdeReservada').val(totalQtde)
            $('#txtQtdeBaixada').val(totalQtdeB)
        } catch (error) {
            console.error(error)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function validacaoRegistroEncontrado() {
        if (!$.fn.DataTable.isDataTable('#tabelaPedido')) {
            throw new Error('Nenhum registro encontrado!')
        }

        if ($('#tabelaPedido').DataTable().data().toArray().length <= 0) {
            throw new Error('Nenhum registro encontrado!')
        }
    }

    retornaHintRelatorio('btnImprimir', 'RelExcluiReserva')

    $('#btnImprimir').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            validacaoRegistroEncontrado()

            const url = `/sisplan/excluireserva/v1/imprimir?`;
            const filtros = await retornaFiltros();
            const bImprimeAutomatico = await verificaImprimirAutomatico('RelExcluiReserva');
            const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 100000, false, 'RelExcluiReserva');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function validaExclulsaoReserva(tabelaSel) {
        if (tabelaSel.length <= 0) {
            throw new Error('Nenhuma reserva selecionada para excluir!')
        }

        if (tabelaSel.filter(f => { return parseFloat(f.QTDE_EXPEDICAO_FAT) > 0 }).length > 0) {
            return true
        } else {
            return false
        }
    }

    async function rotinaExclusao() {
        $.LoadingOverlay('show')
        try {
            const tabela = $('#tabelaPedido').DataTable().data().toArray();
            const tabelaSel = tabela.filter(item => { return item.SEL == 'S' })
            const temQtdeFat = validaExclulsaoReserva(tabelaSel);

            if (temQtdeFat) {
                await msgAguardaConfirmacao(`Existem itens com pedidos ja faturados. ` +
                    `\nDeseja excluir todas as reservas (SIM) ` +
                    `\nDeseja excluir uma reserva por uma (NAO)`,
                    async () => { await excluiReservas(tabelaSel, false) },
                    async () => { await excluiReservas(tabelaSel) })
            } else {
                await excluiReservas(tabelaSel)
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function excluiReservas(tabela, excluiTudo = true) {
        $.LoadingOverlay('show')
        try {
            const arrayExclusao = []
            const listaQtdeBaixada = []
            for (let i = 0; i < tabela.length; i++) {
                if ((!excluiTudo) && (parseFloat(tabela[i].QTDE_EXPEDICAO_FAT) > 0)) {
                    await msgAguardaConfirmacao(`Pedido ${tabela[i].NUMERO} já foi faturado, deseja realmente excluir a reserva?`, async () => {
                        arrayExclusao.push(preencheObjReserva(tabela[i]))
                        if (!parseFloat(tabela[i].QTDE_B) == 0) {
                            listaQtdeBaixada.push(tabela[i].NUMERO)
                        }
                    }, () => { })
                } else {
                    arrayExclusao.push(preencheObjReserva(tabela[i]))
                    if (!parseFloat(tabela[i].QTDE_B) == 0) {
                        listaQtdeBaixada.push(tabela[i].NUMERO)
                    }
                }
            }

            let response = await requisicao("PUT", "/sisplan/excluireserva/v1/excluireserva?", `JSON=${encodeURIComponent(JSON.stringify({ RESERVAS: arrayExclusao }))}`, null);
            if (!response) {
                return;
            }
            if (response.status != 200) {
                let jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                toastClass: "success",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    if (listaQtdeBaixada.length > 0) {
                        msgAlerta(`Os pedidos a seguir, não tiveram o registro de reserva excluído pois já possuem baixa na reserva.` +
                            `\nPedidos: ${listaQtdeBaixada}`)
                    }
                    $('#btnConsultar').trigger('click')
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });

        } catch (error) {
            console.error(error)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function preencheObjReserva(tabela) {
        const obj = {
            NUMERO: tabela.NUMERO,
            CODIGO: tabela.CODIGO,
            COR: tabela.COR,
            TAM: tabela.TAM,
            DEPOSITO: tabela.DEPOSITO,
            IDRESERVA: tabela.ID,
            QTDE: tabela.QTDE,
            QTDEB: tabela.QTDE_B
        }

        return obj
    }

    $('#btnExcluirReserva').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            validacaoRegistroEncontrado()
            msgAguardaConfirmacao('Deseja realmente excluir as reservas selecionadas?', async () => { await rotinaExclusao() })
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function addPesquisaAutocompleta() {
        componenteFiltro('produto', true, true)
        componenteFiltro('pedido', true, true)
        componenteFiltro('cor', true, true)
        componenteFiltro('tamanho', true, true)
        componenteFiltro('grupoPA', true, true)
        componenteFiltro('representante', true, true)
        componenteFiltro('reserva', true, true)
        componenteFiltro('deposito', true, true)
        componenteFiltro('grupoCli', true, true)
        componenteFiltro('cliente', true, true)
        componenteFiltro('grupoPedido', true, true)
        componenteFiltro('colecao', true, true)
        componenteFiltro('tipoPedido', true, true)
        componenteFiltro('statusPed', true, true)
        componenteFiltro('etiqueta', true, true)
    }
});