$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoLimiteOrcamento',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro do limite de orçamento caixa.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaLimiteOrcamento',
                popover: {
                    title: 'Tabela Registros',
                    description: 'Aqui estão todas as regras de limite de orçamento cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("LIMITE_ORCAMENTO_CAIXA");

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovoLimiteOrcamento').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "limiteorcamentocaixa/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE chave", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnMoeda').pesquisa('#txtMoeda', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"]}`, 'Pesquisa Tipo de Moeda', 'MOEDA');
    $('#btnAMoeda').on('click', function () {
        $('#txtMoeda').val('');
    });



    function retornaBotaoOpcoes(data) {
        let retorno = `<div style="text-align:start;"> ` +
            `    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ` +
            `      ${  data  } ` +
            `    </button> ` +
            `    <div class="dropdown-menu"> ` +
            `    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ` +
            `    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ` +
            `</div>`;
        return retorno;
    };

    consultaLimiteOrcamento();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaLimiteOrcamento(true);
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtMoeda').val('');
    });

    async function consultaLimiteOrcamento(bBotao = false) {

        try {
            $.LoadingOverlay("show");
            let response;
            let moeda = pegaChave('#txtMoeda') != '' ? ` AND MOEDA = '${pegaChave('#txtMoeda')}'` : '';

            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"limite_orcamento", "camposSelect":[ "limite_orcamento.id","limite_orcamento.data_de","limite_orcamento.data_ate","limite_orcamento.moeda","moeda.descricao desc_moeda", "limite_orcamento.valor"], "leftJoin":[{"tabela":"moeda", "condicao":"moeda.codmoe = limite_orcamento.moeda"}], "where": ["1=1 ${moeda}"]}`, null);
            } else {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"limite_orcamento", "camposSelect":[ "limite_orcamento.id","limite_orcamento.data_de","limite_orcamento.data_ate","limite_orcamento.moeda","moeda.descricao desc_moeda","limite_orcamento.valor"], "leftJoin":[{"tabela":"moeda", "condicao":"moeda.codmoe = limite_orcamento.moeda"}], "where": null}', null);
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaLimiteOrcamento').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [
                    {
                        "data": "ID"
                    },
                    {
                        "data": "MOEDA"
                    },
                    {
                        "data": "DESC_MOEDA"
                    },
                    {
                        "data": "DATA_DE"
                    },
                    {
                        "data": "DATA_ATE"
                    },
                    {
                        "data": "VALOR"
                    }
                ],
                "columnDefs": [
                    {
                        type: 'date-br',
                        targets: [3, 4],
                        render(data) {
                            if (data) {
                                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                            }
                            return '';
                        }
                    },
                    {
                        targets: [0], render (data) {
                            return retornaBotaoOpcoes(data);
                        }
                    }]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#tabelaLimiteOrcamento').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaLimiteOrcamento').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('LIMITEORCAMENTOCAIXA', data.ID);
            if (registroLiberado) {
                window.location.href = `limiteorcamentocaixa/${data.ID}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaLimiteOrcamento').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaLimiteOrcamento').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('LIMITEORCAMENTOCAIXA', data.ID);
            if (registroLiberado) {
                window.location.href = `limiteorcamentocaixa/${data.ID}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaLimiteOrcamento').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaLimiteOrcamento").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/limiteorcamentocaixa?", `ID=${encodeURIComponent(valorLinha.ID)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});