$(document).ready(async function () {

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtMoeda: {
                required: true,
            },
            txtValor: {
                required: true,
            },
            txtEmpresa: {
                required: true,
            }
        },
        messages: {
            txtMoeda: {
                required: "Informe uma moeda válida."
            },
            txtValor: {
                required: "Informe um valor válido."
            },
            txtEmpresa: {
                required: "Informe ao menos uma empresa."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    $(".submit").click(function () {
        return false;
    });

    componenteFiltro('empresaFantasia', true, false, 'Empresa');

    $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE chave", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnMoeda').pesquisa('#txtMoeda', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"]}`, 'Pesquisa Tipo de Moeda', 'MOEDA');
    $('#btnAMoeda').on('click', function () {
        $('#txtMoeda').val('');
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let id = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('LIMITEORCAMENTOCAIXA', getCookie('usuario'), id);
        window.location.href = `${BASE_URI}/limiteorcamentocaixa`;
    });


    async function preencheFiltroEmpresasRelCliente(empBanco) {
        if (empBanco != '') {
            const pesquisaDescricaoEmpresas = {
                tabela: 'EMPRESA',
                camposSelect: ['EMP_ID', 'EMP_FANTASIA'],
                where: [`EMP_ID IN (${empBanco})`]
            };

            const retornoDescricoes = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaDescricaoEmpresas));

            if (!retornoDescricoes) {
                return;
            };

            insereValorPesquisaVarios('txtEmpresa', 'EMP_ID', 'EMP_FANTASIA', retornoDescricoes);
        }
    };


    if (id != '' && id != 'create') {
        $('#txtMoeda').attr('disabled', true);
        $('#btnMoeda').attr('disabled', true);
        $('#btnAMoeda').attr('disabled', true);
        if (await liberarRegistro('LIMITEORCAMENTOCAIXA', id) == false) {
            window.location.href = '../limiteorcamentocaixa';
        } else {

            try {
                $.LoadingOverlay("show");

                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"limite_orcamento", 
                        "camposSelect":["limite_orcamento.id", "limite_orcamento.moeda", "moeda.descricao desc_moeda",
                        "limite_orcamento.valor", "limite_orcamento.data_de", "limite_orcamento.data_ate", "limite_orcamento.empresas"],
                        "leftJoin":[{"tabela":"moeda", "condicao":"moeda.codmoe = limite_orcamento.moeda"}],
                        "where": ["limite_orcamento.id = '${id}'"]}`, null);

                    let jsonString = await response.json();

                    $('#txtDataDe').val(jsonString.RESULT[0][0].DATA_DE);
                    $('#txtDataAte').val(jsonString.RESULT[0][0].DATA_ATE);
                    $('#txtValor').val(jsonString.RESULT[0][0].VALOR);
                    // $('#txtEmpresas').val(jsonString.RESULT[0][0].BAIRRO);
                    $('#txtEndereco').val(jsonString.RESULT[0][0].ENDERECO);
                    insereValor('#txtMoeda', jsonString.RESULT[0][0].MOEDA, jsonString.RESULT[0][0].DESC_MOEDA);
                    await preencheFiltroEmpresasRelCliente(jsonString.RESULT[0][0].EMPRESAS);

                } catch (error) {
                    console.error(error);
                }

            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $("#gravar").click(
        async function () {

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");
                    const empresas = await formataListas($('#txtEmpresa').val().toString());
                    obj = {};

                    obj.DATA_DE = $('#txtDataDe').val();
                    obj.DATA_ATE = $('#txtDataAte').val();
                    obj.MOEDA = pegaChave('#txtMoeda');
                    obj.VALOR = $('#txtValor').val();
                    obj.EMPRESAS = empresas;
                    obj.id = id != 'create' ? id : -1;
                    
                    const response = await requisicao('POST', '/Sisplan/Cadastros/v1/limiteorcamentocaixa?', `JSON=${encodeURIComponent(JSON.stringify(obj))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    await deletaRegistro('LIMITEORCAMENTOCAIXA', getCookie('usuario'), id);
                    toastr.success(
                        `Cadastro de Limite de Orçamento efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/limiteorcamentocaixa`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                } catch (error) {
                    $.LoadingOverlay("hide");
                    msgErro(`Não foi possível gravar os dados: ${error}`);
                }
            }
        });
});
