<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Relatório de Embarque</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2510.15.1">

    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2510.15.1">
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.2510.15.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2510.15.1">
    <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2510.15.1">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2510.15.1">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2510.15.1">
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2510.15.1" />
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2510.15.1">
    <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2510.15.1">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="dist/css/bootstrap-tagsinput.css?versao=3.2510.15.1">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2510.15.1">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2510.15.1">
    <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2510.15.1">
</head>

<style>
    .border-Field .textoBorda {
        font-size: 1.1em !important;
        text-align: left !important;
        width: auto;
        padding: 0 10px;
        border-bottom: none;
    }

    .border-Field {
        border: 1px solid var(--white-dark) !important;
        /* padding: 0 1.0em 1.0em 1.0em !important; */
        margin: 0 0 1.0em 0 !important;
        -webkit-box-shadow: 0px 0px 0px 0px #000;
        box-shadow: 0px 0px 0px 0px #000;
    }

    #tabelaRelEmbarque_filter {
        display: none;
    }

    .table.dataTable tbody td {
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
    }
</style>

<body class="hold-transition sidebar-mini layout-fixed">
    <main class="wrapper">

        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Relatório de Embarque</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                        <div class="col-sm-6">
                            <!-- <ol class="breadcrumb float-sm-right">
                                
                                <li class="breadcrumb-item active">Relatório de Embarque</li>
                            </ol> -->
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <fieldset>
                                <div class="row">
                                    <div class="col-12">
                                        <div class="buttons">
                                            <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
                                            <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                                            <button id="btnEmail" style="position: absolute; left: 252px;" class="btn-sisp btn btn-primary"><i class="fas fa-envelope pr-1"></i> E-mail XML</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="card">
                                        <div class="col-sm-12 d-flex justify-content-center align-items-center" style="height: 100%;">
                                            <div id="graficoRelEmbarque" style="width: 100%;"></div>
                                        </div>
                                        <div class="col-sm-12 table-responsive card-body">
                                            <table id="tabelaRelEmbarque" class="table table-sm table-select table-hover" width="100%"></table>
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Filtros
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">


                            <div class="col-lg-3 col-md-4 col-sm-4 col-3 form">
                                <fieldset class="form border-Field p-0">
                                    <legend class="textoBorda pb-0 mb-0">Tipo</legend>
                                    <div class="form-row ml-3">
                                        <div class="icheck-primary">
                                            <input type="radio" checked="checked" id="radioEtiqueta" name="tipo">
                                            <label class="labelCheck">Etiqueta</label>
                                        </div>
                                        <div class="icheck-primary">
                                            <input type="radio" id="radioMinuta" name="tipo">
                                            <label class="labelCheck mr-2">Minuta</label>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-md-6 col-sm-6 col-6 form">
                                <fieldset class="form border-Field p-0">
                                    <legend class="textoBorda pb-0 mb-0">Opções</legend>
                                    <div class="form-row ml-3">
                                        <!-- <label class="labelCheck" for="cbTodasEmpresas">   <input type="checkbox" class="configCheck" id="cbTodasEmpresas">  Todas Empresas </label> -->
                                        <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbNotasDenegadas"><label class="labelCheck" for="cbNotasDenegadas">Notas Denegadas</label></div>
                                        <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbTipoNatVendas"><label class="labelCheck" for="cbTipoNatVendas">Tipo Natureza Vendas</label></div>
                                        <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbSemDtEmbarque"><label class="labelCheck" for="cbSemDtEmbarque">Sem Data Embarque</label></div>
                                        <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbExpedicao"><label class="labelCheck d-none" for="cbExpedicao">Expedição</label></div>
                                        <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbEmbalagem"><label class="labelCheck d-none" for="cbEmbalagem">Embalagem</label></div>
                                        <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbImpressoraTermica"><label class="labelCheck d-none" for="cbImpressoraTermica">Impressão Térmica</label></div>
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-lg-2 col-sm-6 col-md-6 p-0 pt-1 mt-2 ml-5">
                                <button class="btn btn-danger btn-sisp" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>
                            </div>


                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <label data-error="wrong" data-success="right" for="txtDtEmissaoDe">Emissao De/ Até:</label>
                                <div class="input-group">
                                    <input type="date" max="2500-12-31" autocomplete="off" value="1200-01-01" class="input-default focus form-control" id="txtDtEmissaoDe" class="form-control">
                                    <input type="date" max="2500-12-31" autocomplete="off" value="2500-12-31" class="input-default focus form-control" id="txtDtEmissaoAte" class="form-control">
                                </div>
                            </div>


                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <label data-error="wrong" data-success="right" for="txtDtSaidaDe">Saída De/ Até:</label>
                                <div class="input-group">
                                    <input type="date" max="2500-12-31" autocomplete="off" value="1200-01-01" class="input-default focus form-control" id="txtDtSaidaDe" class="form-control">
                                    <input type="date" max="2500-12-31" autocomplete="off" value="2500-12-31" class="input-default focus form-control" id="txtDtSaidaAte" class="form-control">
                                </div>
                            </div>

                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <label data-error="wrong" data-success="right" for="txtDtEmbarqueDe">Embarque De/ Até:</label>
                                <div class="input-group">
                                    <input type="date" max="2500-12-31" autocomplete="off" value="1200-01-01" class="input-default focus form-control" id="txtDtEmbarqueDe" class="form-control">
                                    <input type="date" max="2500-12-31" autocomplete="off" value="2500-12-31" class="input-default focus form-control" id="txtDtEmbarqueAte" class="form-control">
                                </div>
                            </div>

                            <!-- <div class="col-lg-3 col-md-6 col-sm-6">
                                <label data-error="wrong" class="labelGearal" data-success="right" for="txtOrdem">Ordem Impressão</label>
                                <div class="input-group">
                                    <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="txtOrdem" class="custom-select">
                                    </select>
                                </div>
                            </div> -->

                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <label data-error="wrong" data-success="right" for="selectTipoNatureza">Tipo Natureza</label>
                                <div class="relative" style="margin-top: 5px;">
                                    <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="selectTipoNatureza" aria-invalid="false">
                                        <option value="">Todas</option>
                                        <option value="1">1 - Saída</option>
                                        <option value="2">2 - Entrada</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12 col-6">
                                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" id="labelTransportadora" for="txtTransportadora">Transportadora: </label>
                                <div class="relative" style="margin-top: 5px;">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtTransportadora" class="form-control" placeholder="Transportadora">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnTransportadora" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaTransportadora" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12 col-6">
                                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtNotas">Lista Notas: </label>
                                <div class="relative" style="margin-top: 5px;">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtNotas" class="form-control" placeholder="Notas">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnNotas" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaNotas" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12 col-4">
                                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" id="labelTipoCliente" for="txtTipoCliente">Tipo Cliente: </label>
                                <div class="relative" style="margin-top: 5px;">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtTipoCliente" class="form-control" placeholder="Tipo Cliente">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnTipoCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaTipoCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12 col-4">
                                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" id="labelRepresentante" for="txtRepresentante">Representante: </label>
                                <div class="relative" style="margin-top: 5px;">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtRepresentante" class="form-control" placeholder="Representante">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaRepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12 col-4">
                                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" id="labelCliente" for="txtCliente">Cliente: </label>
                                <div class="relative" style="margin-top: 5px;">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtCliente" class="form-control" placeholder="Cliente">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12 col-4">
                                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtUF">UF: </label>
                                <div class="relative" style="margin-top: 5px;">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtUF" class="form-control" placeholder="UF">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnUF" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaUF" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12 col-4">
                                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtOperFiscal">Operação Fiscal: </label>
                                <div class="relative" style="margin-top: 5px;">
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtOperFiscal" class="form-control" placeholder="Operação Fiscal">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnOperFiscal" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaOperFiscal" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- <div class="modal-footer">
                        <div class="row">
                            <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222; margin-right: 15px;"><span class="fas fa-trash"></span> Limpar Filtros</button>
                            <button id="btnConsultar" class='btn btn-primary btn-sisp' type='button'><span class="fas fa-search"></span> Consultar </button>
                        </div>
                    </div> -->
                    <div class="modal-footer justify-content-start pl-0">
                        <div class="row col-12">
                            <div class="col-lg-4 col-md-12 col-sm-12 col-4">
                                <label for="txtOrdem">Opção de Relatório:</label>
                                <div class="relative d-flex align-items-center">
                                    <select id="txtOrdem" class="input-default focus custom-select">
                                    </select>
                                    <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-6 col-lg-8 col-md-12 col-sm-12 d-flex justify-content-end align-items-end pr-0">
                                <div class="d-flex">
                                    <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                                        <span class="fas fa-trash"></span> Limpar Filtros
                                    </button>
                                    <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                                        <span class="fas fa-search"></span> Consultar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside><!-- /.control-sidebar -->
        <?php include_once('../../modais.php'); ?>
    </main><!-- /.wrapper -->


    <script src="plugins/jquery/jquery.min.js?versao=3.2510.15.1"></script>
    <script src="dist/js/jquery.maskMoney.min.js?versao=3.2510.15.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2510.15.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2510.15.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2510.15.1"></script>
    <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.2510.15.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.2510.15.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2510.15.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.2510.15.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.2510.15.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.2510.15.1"></script>
    <script src="dist/js/valida_cpf_cnpj.js?versao=3.2510.15.1"></script>
    <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.2510.15.1"></script>
    <script src="dist/js/dataTables.keyTable.js?versao=3.2510.15.1"></script>
    <script src="dist/js/sisplan.js?versao=3.2510.15.1"></script>
    <script src="utils/funcoes.js?versao=3.2510.15.1"></script>
    <script src="utils/cookies.js?versao=3.2510.15.1"></script>
    <script src="dist/js/driver.min.js?versao=3.2510.15.1"></script>
    <script src="config.js?versao=3.2510.15.1"></script>
    <script src="dist/js/popper.min.js?versao=3.2510.15.1"></script>
    <script src="dist/js/tippy-bundle.umd.js?versao=3.2510.15.1"></script>
    <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.2510.15.1"></script>
    <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.2510.15.1"></script>
    <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.2510.15.1"></script>
    <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.2510.15.1"></script>
    <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.2510.15.1"></script>
    <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2510.15.1"></script>
    <script src="graficos/graficos.js?versao=3.2510.15.1"></script>
    <script src="plugins/high-charts/highcharts.js"></script>
    <script src="plugins/high-charts/highcharts-3d.js"></script>
    <script src="plugins/high-charts/cylinder.js"></script>
    <script src="plugins/high-charts/exporting.js"></script>
    <script src="plugins/high-charts/export-data.js"></script>

    <script src="dist/js/bootstrap-tagsinput.min.js?versao=3.2510.15.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('RELEMBARQUE');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/relembarque/relembarque.js?versao=3.2510.15.1`;
            const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
            // nomeTela


            await insereJavaScriptPagina(sArquivo);

            habilitaCamposObrigatoriosTela(nomeTela);
        });
    </script>

</body>

</html>